/**
  Copyright (c) 2010 Freescale Semiconductor
  
  \file  	  GALLO.h
  \brief	  This is the Graphics Memory Allocation Driver Header File
  \brief	  Allocates space in memory for layers on xPC560xS (SPECTRUM)
  \author	  Freescale Semiconductor
  \author	  Automotive Systems Solutions Engineering
  \author	  IM, b06623
  \version	  2.0
  \revision	  $Revision: 132 $
  \date  	  $Date: 2011-01-07 17:35:49 -0600 (Fri, 07 Jan 2011) $
  
  * History:  10/July/2008 - Initial Version (IM)
              23/March/2009 - Added fields to main structure. Check on defragment method (IM)
              11/May/2009   - Release (IM)
              17/May/2010	- Update to support new structure and functions of DMA driver (IM)
              19/Aug/2010	- Partition functionality (IM)

* Copyright (c) 2010, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
  
*/

 
#ifndef 	_GALLO_H_
#define  	_GALLO_H_	  

#include	 "DMA_drv.h"


/**************************** Data Types  ************************************/
typedef  enum
{
	GALLO_ERROR_OK,				/**< Succesful operation */
	GALLO_ERROR_UNINIT, 		/**< The driver is unitialized */
	GALLO_ERROR_ALLOCATED, 		/**< The entity is already allocated */
	GALLO_ERROR_NOTALLOCATED, 	/**< The entity is not allocated */
	GALLO_ERROR_FULL,			/**< There is not enough space for entities */ 
	GALLO_ERROR_DMACHBUSY, 		/**< The selected DMA channel is busy */
	GALLO_ERROR_DMAHWBUSY,		/**< The DMA HW is busy */
	GALLO_ERROR_FAILED,			/**< The operation failed */
	GALLO_ERROR_BUSY			/**< The operation failed */
} GALLO_ErrorType;

typedef  struct
{
	uint8_t   Entity;		/**< Is the ID of the Entity */
	uint32_t  Size;			/**< Is the size in bytes of the entity */
	uint32_t *Address;		/**< Is the link address */
	uint32_t  DynamicAdd;	/**< Is the dynamic address */
} GALLO_StackType;

typedef void (*GALLO_CallbackType)(void);	/**< Is the notification callback of de-fragmentation */

/**************************** CFG Parameters *********************************/

#ifdef DCU_LITE
/* Define the number of slots */
#define  	GALLO_SLOTS	   		(32)

extern uint8_t __GALLO_BEGIN[];
extern uint8_t __GALLO_SIZE[];

extern uint8_t __GALLOLITE_BEGIN[];
extern uint8_t __GALLOLITE_SIZE[];

/* DCU partition */
#define  	GALLO_MEMSTART0	   	((unsigned int)__GALLO_BEGIN)
#define  	GALLO_MEMSIZE0	   	(((unsigned int)__GALLO_SIZE))
/* DCU lite partition */
#define  	GALLO_MEMSTART1	   	((unsigned int)__GALLOLITE_BEGIN)
#define  	GALLO_MEMSIZE1	  	(((unsigned int)__GALLOLITE_SIZE))

#else

/* We are using single display (MPC5606S)*/
/* Define the number of slots */
#define  	GALLO_SLOTS	   		(20)

extern uint8_t __GALLO_BEGIN[];
extern uint8_t __GALLO_SIZE[];

/* DCU partition */
#define  	GALLO_MEMSTART0	   	((unsigned int)__GALLO_BEGIN)
#define  	GALLO_MEMSIZE0	   	(((unsigned int)__GALLO_SIZE))

#endif


/* End of user modifiable parameters */

/**************************** Public Functions *******************************/
void 		GALLO_SetContextDCU();
void 		GALLO_SetContextDCULITE();
void		GALLO_Init(void);
uint32_t	GALLO_TotalFreeMemory(void);
uint32_t 	GALLO_GetSize(uint8_t Entity);
uint32_t* 	GALLO_GetLinkAddress(uint8_t Entity);
uint32_t 	GALLO_GetDynamicAddress(uint8_t Entity);
GALLO_ErrorType GALLO_Allocate(uint8_t Entity, uint32_t Size, uint32_t * AddressPointer);
GALLO_ErrorType	GALLO_DeAllocate( uint8_t  Entity );
GALLO_ErrorType GALLO_DeFragment(uint8_t eDMAChannel, GALLO_CallbackType callback);



/********************** Private Data, DO NOT MODIFY *************************/

//#define GALLO_INVALID_ENTITY	(255)
//extern	GALLO_StackType	GALLO_Stack[GALLO_SLOTS];
//extern	uint16_t	GALLO_StackIndex;
//extern	uint8_t  	GALLO_DeFragmented;

#endif
